<?php
session_start();
require 'db.php';

if (!isset($_SESSION['user_id'])) {
    die("Jums jāpiesakās!");
}

if (!isset($_GET['calendar_id'])) {
    die("Nav norādīts kalendārs!");
}

$calendar_id = $_GET['calendar_id'];

// Pārbaudām, vai lietotājam pieder šis kalendārs
$stmt = $pdo->prepare("SELECT * FROM calendars WHERE id = ? AND user_id = ?");
$stmt->execute([$calendar_id, $_SESSION['user_id']]);
$calendar = $stmt->fetch();

if (!$calendar) {
    die("Jums nav piekļuves šim kalendāram!");
}

// Koplietošana
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $shared_user = $_POST['shared_user'];

    $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ?");
    $stmt->execute([$shared_user]);
    $user = $stmt->fetch();

    if ($user) {
        $stmt = $pdo->prepare("INSERT INTO shared_calendars (calendar_id, user_id) VALUES (?, ?)");
        $stmt->execute([$calendar_id, $user['id']]);
        $success = "Kalendārs veiksmīgi kopīgots!";
    } else {
        $error = "Lietotājs netika atrasts!";
    }
}
?>

<?php include 'header.php'; ?>

<div class="form-container">
    <h2>Koplietot kalendāru: <?php echo htmlspecialchars($calendar['name']); ?></h2>
    
    <?php if (isset($error)) echo "<p class='error'>$error</p>"; ?>
    <?php if (isset($success)) echo "<p class='success'>$success</p>"; ?>
    
    <form action="share_calendar.php?calendar_id=<?php echo $calendar_id; ?>" method="post">
        <label for="shared_user">Lietotāja vārds:</label>
        <input type="text" id="shared_user" name="shared_user" required>

        <button type="submit">Koplietot</button>
    </form>
</div>

<?php include 'footer.php'; ?>
